document.addEventListener("DOMContentLoaded", function () {
    // 1. Voorkomen dat enter een formulier verzendt
    document.addEventListener("keydown", function (event) {
        if (event.key === "Enter" && event.target.tagName === "INPUT") {
            event.preventDefault();
        }
    });

    // 2. Voorkomen dat ontwikkelaarstools geopend worden
    document.addEventListener("keydown", function (event) {
        if (
            event.key === "F12" ||
            (event.ctrlKey && event.shiftKey && (event.key === "I" || event.key === "J" || event.key === "C")) ||
            (event.ctrlKey && event.key === "U")
        ) {
            event.preventDefault();
            event.stopPropagation();
        }
    });

    // 3. Voorkomen dat de pagina opgeslagen wordt
    document.addEventListener("keydown", function (event) {
        if (event.ctrlKey && event.key === "s") {
            event.preventDefault();
            event.stopPropagation();
        }
    });

    // 4. Voorkomen dat de backspace-knop terug navigeert
    document.addEventListener("keydown", function (event) {
        if (event.key === "Backspace" && !["INPUT", "TEXTAREA"].includes(event.target.tagName)) {
            event.preventDefault();
        }
    });

    // 5. Voorkomen dat de URL wordt gewijzigd
    history.pushState(null, null, location.href);
    window.addEventListener("popstate", function () {
        history.pushState(null, null, location.href);
    });

    // Extra beveiliging tegen ontwikkelaarstools
    (function () {
        var devtools = { open: false, orientation: null };
        var threshold = 160;
        
        function detectDevTools() {
            var widthThreshold = window.outerWidth - window.innerWidth > threshold;
            var heightThreshold = window.outerHeight - window.innerHeight > threshold;
            devtools.open = widthThreshold || heightThreshold;
            if (devtools.open) {
                document.body.innerHTML = ""; // Verwijder de gehele pagina-inhoud
            }
        }
        
        window.addEventListener("resize", detectDevTools);
        window.addEventListener("load", detectDevTools);
    })();
});
