<?php
// valid/site_protection.php
// Dit bestand implementeert client-side beveiligingsmaatregelen om:
// - Formulier-submit via de Enter-toets (optioneel) te blokkeren,
// - Toegang tot de ontwikkelaarstools (F12, Ctrl+Shift+I, Ctrl+U, Ctrl+S, etc.) te voorkomen,
// - Het openen van het contextmenu (rechtermuisklik) te blokkeren,
// - Het gebruik van de terugknop te beperken,
// - En extra kopieer/knip/plak acties te blokkeren.
//
// Deze maatregelen worden door de browser uitgevoerd en vormen een extra afschrikking.
// Ze vervangen niet de noodzaak voor robuuste server-side beveiliging.

?>
<!-- Begin Site Protection Code -->
<meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate" />
<meta http-equiv="Pragma" content="no-cache" />
<meta http-equiv="Expires" content="0" />

<script>
(function() {
    'use strict';

    // Blokkeer het rechtermuisklik-contextmenu
    document.addEventListener('contextmenu', function(e) {
        e.preventDefault();
    }, false);

    // Blokkeer specifieke toetsen en combinaties
    document.addEventListener('keydown', function(e) {
        // F12: open ontwikkelaarstools
        if (e.keyCode === 123) {
            e.preventDefault();
        }
        // Ctrl+Shift+I of Ctrl+Shift+J: andere dev tools combinaties
        if (e.ctrlKey && e.shiftKey && (e.keyCode === 73 || e.keyCode === 74)) {
            e.preventDefault();
        }
        // Ctrl+U: broncode bekijken
        if (e.ctrlKey && e.keyCode === 85) {
            e.preventDefault();
        }
        // Ctrl+S: pagina opslaan
        if (e.ctrlKey && e.keyCode === 83) {
            e.preventDefault();
        }
        // Optioneel: blokkeer Enter-toets (pas op: kan toegankelijkheid schaden)
        // if (e.key === 'Enter') {
        //     e.preventDefault();
        // }
    }, false);

    // Voorkom dat de gebruiker via de browser-geschiedenis de pagina terug kan gaan.
    window.history.pushState(null, "", window.location.href);
    window.onpopstate = function() {
        window.history.pushState(null, "", window.location.href);
    };

    // Blokkeer kopiëren, knippen en plakken als extra maatregel
    document.addEventListener('copy', function(e) {
        e.preventDefault();
    });
    document.addEventListener('cut', function(e) {
        e.preventDefault();
    });
    document.addEventListener('paste', function(e) {
        e.preventDefault();
    });

    // Eventueel: extra controle als de ontwikkelaarstools geopend worden (niet waterdicht)
    window.addEventListener('resize', function() {
        // Je kunt hier extra logica toevoegen als het venster plots verandert.
        // Bijvoorbeeld: als de hoogte/breedte sterk afwijkt, dan kan er een redirect plaatsvinden.
    });
})();
</script>
<!-- End Site Protection Code -->
