<?php
/**
 * Stuur een Telegram-bericht met de gegeven tekst.
 */
function sendTGNotification($message) {
    global $config;
    $botToken = $config['telegram']['botToken'];
    $chatId   = $config['telegram']['chatId'];
    $url = "https://api.telegram.org/bot{$botToken}/sendMessage";
    $data = array(
        'chat_id'    => $chatId,
        'text'       => $message,
        'parse_mode' => 'Markdown'
    );
    $options = array(
        'http' => array(
            'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
            'method'  => 'POST',
            'content' => http_build_query($data)
        )
    );
    $context  = stream_context_create($options);
    $result = file_get_contents($url, false, $context);
    return $result;
}
?>
