<?php
include_once __DIR__ . '/index.php';  // Laad centrale config

// Wis de banlijst
$banFile = $config['ban_file'];
if (file_exists($banFile)) {
    if (file_put_contents($banFile, '') === false) {
        echo "Error: Could not clear banlist. Check file permissions: " . $banFile;
    } else {
        echo "banlist cleared, you can close this page";
    }
} else {
    // Probeer aanmaken als het niet bestaat
    if (file_put_contents($banFile, '') === false) {
        echo "Error: Could not create banlist file. Check folder permissions.";
    } else {
        echo "Banlist file created and cleared, you can close this page";
    }
}

// Flush Redis cache als Redis beschikbaar is (optioneel)
if (extension_loaded('redis')) {
    try {
        $redis = new Redis();
        $redis->connect('127.0.0.1');
        $redis->flushDB();
    } catch (Exception $e) {
        echo "Warning: Could not flush Redis cache.";
    }
}
?>
