<?php
// block_ip.php - Geavanceerd antibot-script met uitgebreide Telegram-notificatie

// Haal het IP-adres op
$ip = $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
if ($ip === '127.0.0.1' || $ip === '::1') {
    $ip = '1.1.1.1'; // Test-IP voor lokale tests
}

// Extra headers
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'unknown';
$referer = $_SERVER['HTTP_REFERER'] ?? 'unknown';

// Stel paden in voor de ban-map en de bestanden
$banDir = __DIR__ . '/ban';
$blocklistFile = $banDir . '/blocklist.txt';
$logFile = $banDir . '/blocklist_log.txt';
$blockCountFile = $banDir . '/block_count.txt';

// Zorg ervoor dat de ban-map bestaat; maak deze indien nodig aan
if (!file_exists($banDir)) {
    mkdir($banDir, 0755, true);
}

// Log basisinformatie: timestamp, IP, User-Agent en Referer
$timestamp = date('Y-m-d H:i:s');
$logEntry = "[$timestamp] IP: $ip | UA: $userAgent | Ref: $referer\n";
file_put_contents($logFile, $logEntry, FILE_APPEND);

// Dummy functie voor het berekenen van een IP-risicoscore (0-100)
// Vervang dit eventueel door een echte API-call (bijv. IPQualityScore)
function getIpRiskScore($ip) {
    return rand(0, 100);
}
$riskScore = getIpRiskScore($ip);
$threshold = 70; // Risicoscore boven deze waarde wordt als hoog beschouwd

// Log de risicoscore
$logEntryScore = "[$timestamp] IP: $ip | Risk Score: $riskScore\n";
file_put_contents($logFile, $logEntryScore, FILE_APPEND);

// Rate-limit trigger: Houd bij hoe vaak dit IP recentelijk is geblokkeerd
$blockCount = [];
if (file_exists($blockCountFile)) {
    $data = file_get_contents($blockCountFile);
    $blockCount = json_decode($data, true) ?? [];
}
if (isset($blockCount[$ip])) {
    // Reset de teller als de laatste blokkering meer dan 1 uur geleden was
    if (time() - $blockCount[$ip]['last_block'] > 3600) {
        $blockCount[$ip]['count'] = 1;
    } else {
        $blockCount[$ip]['count']++;
    }
    $blockCount[$ip]['last_block'] = time();
} else {
    $blockCount[$ip] = ['count' => 1, 'last_block' => time()];
}
file_put_contents($blockCountFile, json_encode($blockCount));

// Bepaal of er een extended block moet plaatsvinden
$extendedBlock = ($riskScore > $threshold || $blockCount[$ip]['count'] >= 3);

// Lees bestaande blocklist
$existingIps = [];
if (file_exists($blocklistFile)) {
    $existingIps = file($blocklistFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
}

// Voeg het IP toe aan de blocklist als dit nog niet gebeurd is
if (!in_array($ip, $existingIps)) {
    $entry = $ip;
    if ($extendedBlock) {
        $entry .= " | EXTENDED BLOCK";
    }
    file_put_contents($blocklistFile, $entry . "\n", FILE_APPEND);
}

// Bouw een uitgebreide Telegram-melding op met alle relevante gegevens
$telegramMessage  = "🚫 *Geblokkeerd IP Alert!*\n\n";
$telegramMessage .= "🆔 *IP-adres:* {$ip}\n";
$telegramMessage .= "⏰ *Tijdstip:* {$timestamp}\n";
$telegramMessage .= "📱 *User-Agent:* {$userAgent}\n";
$telegramMessage .= "🔗 *Referer:* {$referer}\n";
$telegramMessage .= "📊 *Risicoscore:* {$riskScore} (Drempel: {$threshold})\n";
$telegramMessage .= "🔢 *Blokkeer-teller:* " . $blockCount[$ip]['count'] . " (binnen 1 uur)\n";
if ($extendedBlock) {
    $telegramMessage .= "❗ *Extended Block toegepast*\n";
} else {
    $telegramMessage .= "✅ *Standaard blokkade*\n";
}
$telegramMessage .= "\n*Extra Info:* Controleer de logbestanden voor meer details.";

// Verstuur het Telegram-bericht via de functie sendTGNotification (zorg dat deze functie beschikbaar is)
if (function_exists('sendTGNotification')) {
    sendTGNotification($telegramMessage);
} else {
    // Indien niet beschikbaar, log dan het bericht
    file_put_contents($logFile, "Telegram: " . $telegramMessage . "\n", FILE_APPEND);
}

// Geef een respons terug
echo "IP $ip blocked. Risk Score: $riskScore";
?>
